#pragma once

#include "bass.h"

void SetupSound(void);
void ShutdownSound(void);

enum SoundID {
	HTEngineStartupSound,
	HTEngineHoverSound,
	HTEngineShutdownSound,
	HTMGunFireSound,
	HTMGunTankHit,
	HTTankInpactSoft,
	HTMenuChangeItem,
	HTMenuSelect,
	HTApplaud,
	HTExplode,
	NUM_SOUNDS
};

typedef enum {
	// These have been combined
	MIntroSong=0,
	MMenuSong=0,

	MGameSong1,
	MGameSong2,
	MGameSong3,
	NUM_SONGS
} MusicID;

struct SOUND_DATA {
	HSTREAM song[NUM_SONGS];
	bool musicPlaying;
	int curSong;

	HSAMPLE effect[NUM_SOUNDS];
	BASS_SAMPLE effectInfos[NUM_SOUNDS];
	HCHANNEL effectchannels[NUM_SOUNDS];

	int globalvol;
};

extern char* songname[NUM_SONGS];

extern struct SOUND_DATA snd;

void PlaySong(int snum, bool restart=true, bool loop=false, int vol=50);
void CheckSong();
void StopSong(int snum);
void StopSong();
void PlaySound(int snum, int loop=-1, int vol=-1, int pan=-101);
void StopSound(int snum);
double GetSoundLen(int snum);

void SetMusicVol(int vol);

// Any parms not specified are unaffected
void ModSoundParms(int snum, float rel_vol=-1, float rel_freq=-1, int pan=-101);