#include "global.h"

struct SOUND_DATA snd;


char* songname[NUM_SONGS] = {
	"Dragula (Rob Zombie)",
	"Spybreak! (Propellerheads)",
	"Celebrity Skin (Hole)",
	"Mary, Mary (Chumbawumba)",
};


// Always have server sound off
#ifdef HT_SERVER
#define NO_SOUND
#else

// Add/remove this for enabling/disabling the client sound
//#define NO_SOUND

#endif

#ifndef NO_SOUND

#pragma comment(lib,"bass.lib")

char* musicfname[NUM_SONGS] = {
	"../data/introsong.mp3",
	//"../data/menusong.mp3",  // There is no menu song -- intro song continues
	"../data/gamesong3.mp3",
	"../data/gamesong.mp3",
	"../data/gamesong2.mp3"
};

char* sndeffectfname[NUM_SOUNDS] = {
	"../data/mystartup.wav",
	"../data/myhover.wav",
	"../data/myshutdown.wav",
	"../data/mgfire_wecho.wav",
	"../data/tink.wav",
	"../data/boing.wav",
	"../data/change.wav",
	"../data/select.wav",
	"../data/clap.wav",
	"../data/explode.wav",
};

#define MAX_SIMUL_SOUNDS 1

void ModSoundParms(int snum, float rel_vol, float rel_freq, int pan)
{
	DWORD curFreq, curVol;
	int curPan;
	// Load the current values -- if we can't do this, then the sound
	// isn't actually playing right.
	if (!BASS_ChannelGetAttributes(snd.effectchannels[snum],&curFreq,&curVol,&curPan))
		return;
	if (rel_vol != -1)	curVol = snd.effectInfos[snum].volume * rel_vol;
	if (rel_freq != -1)  curFreq = snd.effectInfos[snum].freq * rel_freq;
	if (pan != -101)     curPan = pan;
	/*
	printf("Setting volume from %d to %d, freq from %d to %d\n",
		(int)snd.effectInfos[snum].volume, (int)curVol,
		(int)snd.effectInfos[snum].freq, (int)curFreq);
	*/
	BASS_ChannelSetAttributes(snd.effectchannels[snum],curFreq,curVol,curPan);
}

double GetSoundLen(int snum)
{
	return snd.effectInfos[snum].length / (double) snd.effectInfos[snum].freq;
}

void PlaySong(int snum, bool restart, bool loop, int vol)
{
	DWORD flags=0;
	BOOL flush=FALSE;
	if (loop)	flags |= BASS_SAMPLE_LOOP;
	if (restart) flush=TRUE;
	StopSong();
	BASS_StreamPlay(snd.song[snum],flush,flags);
	BASS_ChannelSetAttributes(snd.song[snum],-1,vol,-101);
	snd.musicPlaying = true;
	snd.curSong = snum;
}
void CheckSong()
{
	if (snd.musicPlaying)
		snd.musicPlaying = BASS_ChannelIsActive(snd.song[snd.curSong]) == TRUE;
}
void StopSong(int snum)
{
	BASS_ChannelStop(snd.song[snum]);
}
void StopSong()
{
	if (snd.musicPlaying)
		BASS_ChannelStop(snd.song[snd.curSong]);
}


void PlaySound(int snum, int loop, int vol, int pan)
{
	snd.effectchannels[snum] = BASS_SamplePlayEx(
		snd.effect[snum],		// Select the right sample
		0,						// Start at the beginning
		-1,						// Use the samples default freq
		vol,					// Use the specified volume (or default vol of -1)
		pan,					// Use the specified panning (or default panning -101)
		loop					// Use the specified looping (or default looping -1)
		);
}
void StopSound(int snum)
{
	BASS_SampleStop(snd.effect[snum]);
}

void SetupSound(void)
{
	int snum;

	/* Check that BASS 1.2 was loaded */
	if (BASS_GetVersion()!=MAKELONG(1,2)) {
		printf("BASS version 1.2 was not loaded -- Incorrect or missing BASS.DLL");
		return;
	}
	/* Initialize digital sound - default device, 44100hz, stereo, 16 bits, no syncs used */
	if (!BASS_Init(-1,44100,0,glutarConfig.hWnd)) {
		printf("Can't initialize digital sound system");
		return;
	}

	// Load all songs or initialize empty sounds to 0
	for (snum=0; snum < NUM_SONGS; snum++)
		if (musicfname[snum])
		{
			snd.song[snum] = BASS_StreamCreateFile(FALSE,musicfname[snum],0,0,BASS_SAMPLE_MONO);
			if (snd.song[snum] == 0)
				printf("Error: Could not load song %s\n",snd.song[snum]);
		}
		else
			snd.song[snum] = 0;

	// Load all samples or initialize empty sounds to 0
	for (snum=0; snum < NUM_SOUNDS; snum++)
	{
		if (sndeffectfname[snum])
		{
			printf("Loading %s...\n",sndeffectfname[snum]);
			snd.effect[snum] = BASS_SampleLoad(FALSE, sndeffectfname[snum],0,0,MAX_SIMUL_SOUNDS,BASS_SAMPLE_OVER_POS);
			if (snd.effect[snum] == 0)
				printf("Error: Could not load sound %s\n",sndeffectfname[snum]);
			else
				BASS_SampleGetInfo(snd.effect[snum],&snd.effectInfos[snum]);
		}
		else
			snd.effect[snum] = 0;
		snd.effectchannels[snum] = 0;
	}
	
	snd.globalvol = 10;
	snd.musicPlaying = false;
	snd.curSong = MIntroSong;

	// Initialize to default volume
	BASS_SetVolume(snd.globalvol);

	// Start digital output
	BASS_Start();
}

void ShutdownSound(void)
{
	int snum;

	/* Stop digital output */
	BASS_Stop();

	/* Free all digital samples */
	for (snum=0; snum < NUM_SOUNDS; snum++)
		BASS_SampleFree(snd.effect[snum]);

	/* Free streaming music, if any */
	for (snum=0; snum < NUM_SONGS; snum++)
		BASS_StreamFree(snd.song[snum]);

	/* Close digital sound system */
	BASS_Free();
}

#else
void ModSoundParms(int snum, float rel_vol, float rel_freq, int pan) {}
void PlaySong(int snum, bool restart, bool loop, int vol) {}
void PlaySound(int snum, int loop, int vol, int pan) {}
void StopSound(int snum) {}
void StopSong(int snum) {}
void StopSong() {}
void SetupSound(void) {}
void ShutdownSound(void) {}
double GetSoundLen(int snum)
{	return 0.5;	}
#endif