/*

  Adapted from the Simple Client / Server example in Microsoft's
  DirectX 8.1 SDK

	(Basically rewritten)

*/

//----------------------------------------------------------------------------
// File: SimpleClientServer.h
//
// Desc: 
//
// Copyright (c) 1999-2000 Microsoft Corp. All rights reserved.
//-----------------------------------------------------------------------------
#include "global.h"

#pragma once

//-----------------------------------------------------------------------------
// Defines, and constants
//-----------------------------------------------------------------------------
#define MAX_PLAYER_NAME         30
#define LOCAL_PLAYER_IDX			0

//-----------------------------------------------------------------------------
// App specific DirectPlay messages and structures 
//-----------------------------------------------------------------------------
#define HT_MSGID_SETUP_GAME			1
#define HT_MSGID_SET_ID					2
#define HT_MSGID_CREATE_PLAYER		3
#define HT_MSGID_DESTROY_PLAYER		4
#define HT_MSGID_UPDATE_PLAYER		5

#define HT_MSGID_COMMAND_TO_SERVER	6
#define HT_MSGID_UPDATE_INPUT			7

#define HT_MSGID_CHAT					8
#define HT_MSGID_NOTIFY_KILL			9
#define HT_MSGID_NOTIFY_SUICIDE		10
#define HT_MSGID_NOTIFY_BURNED		11
#define HT_MSGID_NOTIFY_EXPLODE		12

enum HT_COMMAND_ID_TYPE { 
	HT_CMDID_SUICIDE,				// Instructs server that a player wishes to act honorably
};

// Change compiler pack alignment to be BYTE aligned, and pop the current value
#pragma pack( push, 1 )

// Base information include in all messages
struct HTMSG_GENERIC
{
    BYTE dwType;
};

struct HTMSG_PLAYER_CONFIG
{
	int nextRespawnModelNum;
};

struct HTMSG_NOTIFY_KILL : public HTMSG_GENERIC
{
	DWORD pid1;
	DWORD pid2;
};

struct HTMSG_NOTIFY_EXPLODE : public HTMSG_GENERIC
{
	int x;
	int y;
};

struct HTMSG_SETUP_GAME : public HTMSG_GENERIC
{
	BYTE mapID;						// id of the map to use
	DWORD timestamp;				// server time at start of game
	unsigned int treeSeed;		// random seed for making trees
	unsigned int numTrees;		// number of generated trees
};

struct HTMSG_COMMAND_TO_SERVER : public HTMSG_GENERIC
{
	DWORD pid;										// dpnid of the player
	HT_COMMAND_ID_TYPE commandID;				// allows player to send commands to server
};

// To initialize the game
struct HTMSG_SET_ID : public HTMSG_GENERIC
{
    DWORD pid;						// dpnid of the player
};

// To create a player (i.e. joining a game)
struct HTMSG_CREATE_PLAYER : public HTMSG_GENERIC
{
    DWORD pid;                   // dpnid of the player created
    TCHAR playerName[MAX_PLAYER_NAME];   // name of the player created
	 int modelnum;						// player's selected model
};

// To destroy a player (i.e. leaving the game)
struct HTMSG_DESTROY_PLAYER : public HTMSG_GENERIC
{
    DWORD pid;                   // dpnid of the player destroyed
};

// For the server to inform the client of everyone's status
struct HTMSG_UPDATE_PLAYER : public HTMSG_GENERIC
{
	DWORD pid;
	DWORD timestamp;
	vec3f pos;
	vec3f vel;
	short int armor;
	short int kills;
	short int deaths;
	TankState_type state;
	CompactInputStatus_type input;
};

struct HTMSG_CHAT_HEADER : public HTMSG_GENERIC
{
	DWORD pidFrom;
	short int messageLength;
};
struct HTMSG_CHAT_FULL : public HTMSG_GENERIC
{
	DWORD pidFrom;
	short int messageLength;
	char msg[MAX_PATH];
};

// For the client to inform the server of the client's current input
struct HTMSG_UPDATE_INPUT : public HTMSG_GENERIC
{
	DWORD pid;
	DWORD timestamp;
	CompactInputStatus_type input;
};

// Pop the old pack alignment
#pragma pack( pop )
