#pragma once

#include "simpleclientserver.h"
#include "HTNetClient.h"

typedef enum { MS_MAIN, MS_JOIN_NETWORK_GAME, MS_JOINING_NETWORK_GAME, MS_SETTINGS, MS_IN_GAME_MAIN } MenuState;

//#define MAX_PLAYER_NAME 20
#define MAX_SERVER_NAME_LENGTH 50

typedef enum {
	SETTINGS_PANEL_VIDEO_CHOICE,
	SETTINGS_PANEL_CREDITS_CHOICE,
	SETTINGS_PANEL_CONTROL_CHOICE,
	SETTINGS_PANEL_PLAYER_CHOICE,
	SETTINGS_PANEL_BACKGROUND,
	NUM_SETTINGS_PANELS
} SettingsPanelIDs;
typedef enum {
	SETTINGS_PANEL_BKG_SEL,
	SETTINGS_PANEL_BKG_UNSEL,
	SETTINGS_PANEL_ITEM_SEL,
	SETTINGS_PANEL_ITEM_TEXT,
	NUM_SETTINGS_PANEL_COLORS
} SettingsPanelColorIDs;

const float settingsMenuPanelSelectedTargetAlpha = 0.9;
const float settingsMenuPanelUnselectedTargetAlpha = 0.3;

class MenuInformation
{
	protected:
		tex_object_2D texob;
		bool texture_data_loaded;
		rgb_image_type textureimage;

		tex_object_2D worldmasktexob;
		gs_image_type worldmaskimage;

		display_list setMenuMatrices;

	protected:

		timet remainingStatusMessageDisplayTime;
		float statusMessageAlpha;
		float statusMessageFadeSpeed;
		
		float settingsMenuChoiceAlpha[NUM_SETTINGS_PANELS];
		float settingsMenuChoiceFadeSpeed;
		int   selectedSettingsMenuChoice;
	
		int   selectedVideoSettingsMenuItem;

		int  workingVideoResolutionIdx;
		int  workingVideoBitdepthIdx;
		int  workingVideoFreqIdx;
		bool workingVideoFullscreen;

		float tankModelRotation;
		float tankModelRotationSpeed;

		void SelectSettingsMenu(int menu);

	public:
		inline void SetMenuDisplayMode() { setMenuMatrices.call_list(); }

		void DrawMenuScreenBkg();
		void DrawMainMenu();
		void DrawNetMenu();
		void DrawStatusMessage(bool forceUpdate=true);
		void DrawSettingsMenu();
		void DrawInGameMenu();
		void DrawMenuMouse();

		void ResetVideoSettingsMenu();

		void DrawVideoSettingsMenu();
		void DrawGraphicsSettingsMenu();
		void DrawControlSettingsMenu();
		void DrawPlayerSettingsMenu();

		void DrawMenuWorld();
		void MaskoutMenuWorld();

		int  workingPlayerTankModel;
		char workingPlayerName[MAX_PLAYER_NAME];
		char workingServerAddress[MAX_SERVER_NAME_LENGTH+1];

		bool bEditingLabel;

		char StatusString[MAX_PATH];
		double networkStuffTimeoutTime;		// General time for network event timeouts

		HTClientStatus_type lastNetworkStatus;
		bool abortingNetworkConnection;

		float currentWorldFade;
		float targetWorldFade;
		float worldFadeSpeed;

	public:
		void ResetMenuWorld();

		bool inGameMenu;

		void HandlePlayerSettingsMouse(bool click);
		void HandleVideoSettingsMouse(bool click);
		void SetStatusMessage(bool forceUpdate, timet minDisplayTime, char* fmt, ...);
		MenuState state;

		MenuInformation();

		void update(timet dtime);
		void UpdateMenuWorld(timet dtime);

		void Draw();
		void ReleaseModels();
		bool RegisterModels();
		bool HandleInput(InputEvent_type e);
		void HandleMouse(bool click);
		bool LoadData();

		void ChangeMenu(MenuState newmenu);
		void SetItemSel(int idx);
		void SelectItem();

		float selectionPosition;
		float selectionOriPosition;
		float selectionVel;
		float selectionAcc;

		int selectedItem;
		int selectedNetServer;
		int numItems;

		WorldInformation menu_world;
};