#pragma once

#define NUM_LETTERS 9

class IntroInformation
{
	public:
		WorldInformation* world;
		GLFont* titlefont;
		GLFont* titleoutline;
		GLFont* infofont;

		timet currentTime;
		timet currentEventTime;
		int currentEvent;
		timet totalIntroTime;
		timet dtime;

		float progress;

		float t1angle;

		InputStatus_type t2input;

		bool finished;

		IntroInformation();

		timet	LetterTime;
		static char* LetterStrings[NUM_LETTERS];
		float LetterAlphas[NUM_LETTERS];
		float LetterRotation[NUM_LETTERS];
		float OutlineAlphas[NUM_LETTERS];

		static timet TotalTitleRotationTime;
		static timet TotalOutlineFadeTime;
		static float LetterActionOverlap;

		timet LetterRotateStartTime[NUM_LETTERS];
		timet OutlineFadeStartTime[NUM_LETTERS];
		timet PerLetterRotationTime;
		timet PerOutlineFadeTime;


		void DrawLetters();
		void UpdateLetters(timet dtime);

		void Reset();
		void update(timet dtime);
		void Draw();
		void LoadData();
		void RegisterModels();
		void ReleaseModels();

		void DoFadeIn();
		void DoPanDown();
		void DoLookAround();
		void DoKillerAttack();
		void DoVictimExplode();

		void StartIntro();
		void ExitIntro();
};