#include "global.h"

char* IntroInformation::LetterStrings[NUM_LETTERS] = {
	"H", "O", "V", "E", "R", "T", "A", "N", "K"
};

timet IntroInformation::TotalTitleRotationTime = 10;
timet IntroInformation::TotalOutlineFadeTime = 5;
float IntroInformation::LetterActionOverlap = 0.7;

typedef enum {
	ITE_FADEIN,
	ITE_ADMIRE,
	ITE_PANDOWN,
	ITE_VICTIM_LOOKAROUND,
	ITE_KILLER_ATTACK,
	ITE_TITLE_FADE,
	ITE_VICTIM_EXPLODE,
	ITE_END_INTRO,
	NUM_TIMED_EVENTS
} TimedEvents;

float EventDurations[NUM_TIMED_EVENTS] = {
	6.0,		// ITE_FADEIN,
	1.0,		// ITE_ADMIRE,
	3.0,		// ITE_PANDOWN,
	4.0,		// ITE_VICTIM_LOOKAROUND,
	6.0,		// ITE_KILLER_ATTACK,
	10.0,		// ITE_TITLE_FADE,
	0.5,		// ITE_VICTIM_EXPLODE,
	1.0,		// ITE_END_INTRO,
};

void IntroInformation::StartIntro()
{
	Reset();
	PlaySong(MIntroSong);
}

IntroInformation::IntroInformation()
{
	totalIntroTime = 0;
	for (int i=0; i < NUM_TIMED_EVENTS; i++)
		totalIntroTime += EventDurations[i];
}

void IntroInformation::Draw()
{
	world->SetDisplayMode();

	world->Draw();

	game.menu.SetMenuDisplayMode();

	DrawLetters();

	game.menu.SetMenuDisplayMode();

	infofont->setScale(2,2,1);
	glColor4f(1.0,1.0,1.0,0.5);
	infofont->printxyz(0,0,0,"%5.1f sec remaining",totalIntroTime-currentTime);
}

void IntroInformation::ExitIntro()
{
	finished = true;

	//StopSong(MMenuSong);
	game.SetState(GS_MENU);
	PlaySound(HTExplode);
	//PlaySong(MMenuSong);
}

void IntroInformation::DoVictimExplode()
{
	/*
	if (progress > 0.1)
	{
		t2input.thrust = false;
		t2input.fire = false;
		t2input.brake = true;
	}
	//t2input.right = true;
	t2input.turnAmount = (180 - world->tank[2].model.dir)/5.0*dtime;

	if (world->tank[1].state == TS_NORMAL)
	{
		world->tank[1].SetState(TS_EXPLODING);
	}
	else
	{
		world->tank[0].model.pos = world->tank[1].model.pos;
		//world->eyedyn.followerOffset = vec3f(50,0,50);
	}
	*/
	t2input.brake = true;
	t2input.turnAmount *= 0.8;

	static bool followingT2 = false;
	//if (progress > 0.4 || followingT2)
	{
		world->tank[0].model.pos = world->tank[2].model.pos;

	}

	world->tank[2].HandleInput(dtime,t2input);
	world->update(dtime);
}

void IntroInformation::DoKillerAttack()
{
	float iprog = 1.0-progress;

	t2input.fire = true;

	if (progress > 0.5)
	{
		if (world->tank[1].state == TS_NORMAL)
		{
			world->tank[1].SetState(TS_EXPLODING);
		}
		t2input.turnAmount = (progress-0.5)*5;
		t2input.thrust = false;
	}
	if (progress > 0.7)
	{
		t2input.fire = false;
	}

	world->tank[2].HandleInput(dtime,t2input);
	world->update(dtime);

	vec3f offset(90,0,35 - 10*iprog*iprog);
	vec3f tgtoff(0,0,10);
	static vec3f olddyn;
	// Checking t2
	if (progress < 0.2)
	{
		world->tank[0].model.pos = world->tank[2].model.pos;
		offset[X] = -offset[X];
		offset[Z] += 10;
		world->eyepoint.pos = world->tank[2].model.pos + offset;
	}
	else if (progress < 0.4)
	{
		world->eyepoint.pos = world->tank[1].model.pos + offset;
		world->tank[0].model.pos = world->tank[1].model.pos + tgtoff;
		olddyn = world->eyedyn.followerOffset;
	}
	else if (progress < 0.8)
	{
		float amt = progress-0.4;
		world->eyedyn.followerOffset = olddyn + vec3f(-150*amt,0,70*amt);
		//world->eyepoint.vel = vec3f(-10,0,0);
		/*
		float amt = progress-0.4;
		vec3f breakaway( amt * 50, 0, amt * 10 );
		world->eyepoint.pos = world->tank[1].model.pos + offset;
		//world->eyedyn.followerOffset = vec3f(50,0,50);
		world->tank[0].model.pos = world->tank[1].model.pos + tgtoff;
		world->tank[0].model.pos[Z] += (progress-0.4)*20;
		*/
	}
}

void IntroInformation::DoLookAround()
{
	float iprog = 1.0-progress;

	t2input.thrust = true;

	t1angle = 50*(1.0-sin(2.0*progress*M_PI));
	world->tank[1].model.dir = t1angle;

	world->tank[2].HandleInput(dtime,t2input);

	world->update(dtime);

	vec3f offset(80 + 10*progress,0, 20 + 5*progress*progress);
	world->eyepoint.pos = world->tank[1].model.pos + offset;

	// Checking t2
	if (progress > 0.5)
	{
		world->tank[0].model.pos = world->tank[2].model.pos;
		offset[X] = -offset[X];
		offset[Z] += 10;
		world->eyepoint.pos = world->tank[2].model.pos + offset;
	}
}

void IntroInformation::DoPanDown()
{
	float iprog = 1.0-progress;

	if (world->tank[1].hoverStatus == HOVER_OFF)
		world->tank[1].StartHover();

	vec3f offset(50+30*progress,0,80*(1.0-progress)+20);
	vec3f tgtoff(0,0,90*(1.0-progress)+10);

	//t1angle = 25*progress+25;
	t1angle = 25*progress+25 + 50*(1.0-sin(2.0*progress*M_PI)) * iprog*iprog;
	world->tank[1].model.dir = t1angle;

	world->tank[2].HandleInput(dtime,t2input);
	world->update(dtime);

	world->tank[0].model.dir = 0;
	world->eyepoint.pos      =	world->tank[1].model.pos + offset;
	world->tank[0].model.pos = world->tank[1].model.pos + tgtoff;
	world->eyedyn.followerOffset = offset;

	/*// Checking t2
	world->tank[0].model.pos = world->tank[2].model.pos;
	offset[X] = -offset[X];
	world->eyepoint.pos = world->tank[2].model.pos + offset;
	*/
}

void IntroInformation::DoFadeIn()
{
	world->update(0.0);
	world->lightCol = vec4f(progress,progress,progress,1.0);
	t1angle = 0;

	//world->tank[2].HandleInput(dtime,t2input);
	//world->update(dtime);
}

void IntroInformation::update(timet in_dtime)
{
	dtime = in_dtime;
	currentTime += dtime;
	currentEventTime += dtime;		


	if (currentEventTime > EventDurations[currentEvent])
	{
		if (currentEvent == ITE_END_INTRO)
			ExitIntro();
		else
		{
			currentEvent++;
			currentEventTime=0;

			if (currentEvent == ITE_VICTIM_EXPLODE)
			{
				//PlaySound(HTExplode);
				//world->tank[2].SetState(TS_EXPLODING);
			}
			if (currentEvent == ITE_VICTIM_LOOKAROUND)
			{
				vec3f offset( -1500, 0, 0 );
				world->tank[2].active = true;
				world->tank[2].model.pos = world->tank[1].model.pos + offset;
				world->tank[2].model.vel = vec3f(100,0,0);//offset*0.10;
				world->tank[2].model.dir = 0;
				world->tank[2].state = TS_NORMAL;
				world->tank[2].hoverStatus = HOVER_GOING;
			}
		}
	}

	world->currentTime += dtime;
	world->dtime = dtime;

	world->eyeDirection = game.world.eyepoint.pos - game.world.tank[0].model.pos;

	progress = currentEventTime / EventDurations[currentEvent];

	switch (currentEvent)
	{
		case ITE_FADEIN:
			DoFadeIn();
			break;
		case ITE_ADMIRE:
			break;
		case ITE_PANDOWN:
			DoPanDown();
			break;
		case ITE_VICTIM_LOOKAROUND:
			DoLookAround();
			break;
		case ITE_KILLER_ATTACK:
			DoKillerAttack();
			break;
		case ITE_VICTIM_EXPLODE:
		case ITE_TITLE_FADE:
			DoVictimExplode();
			break;
		default:
		case ITE_END_INTRO:
			break;
	}

	//if (currentEvent >= ITE_TITLE_FADE)
	if (currentEvent >= ITE_VICTIM_LOOKAROUND)
		UpdateLetters(dtime);
}

void IntroInformation::UpdateLetters(timet dtime)
{
	LetterTime += dtime;

	for (int i=0; i < NUM_LETTERS; i++)
	{
		float letProgress = (LetterTime-LetterRotateStartTime[i])/PerLetterRotationTime;
		if (letProgress >= 0)
		{
			if (letProgress >= 1)
			{
				LetterRotation[i] = 0;
				LetterAlphas[i] = 1.0;
			}
			else
			{
				LetterRotation[i] = 90 * (1.0 - letProgress);
				LetterAlphas[i] = letProgress;
			}
		}
		float outlineProgress = (LetterTime-OutlineFadeStartTime[i])/PerOutlineFadeTime;
		if (outlineProgress >= 0)
		{
			if (outlineProgress >= 1)
				OutlineAlphas[i] = 1.0;
			else
				OutlineAlphas[i] = outlineProgress;
		}

	}
}

void IntroInformation::DrawLetters()
{
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	//gluOrtho2D(0,100,0,100);
	//glFrustum( -50, 50, -50, 50, 1, 40 );
	glFrustum( -50, 50, -50, 50, 1, 2 );
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glTranslatef( -50, -50, -1.5 );

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);

	vec3f fillTitleColor( 1.0 , 0.0 , 0.0 );
	vec3f outlineTitleColor( 1.0, 1.0, 0.0 );
	titlefont->setScale(20,20,1);
	for (int i=0; i < NUM_LETTERS; i++)
	{
		float x = ((float)i+1.0)/10.0 * 100;
		float y = 82.5;

		glPushMatrix();
		glTranslatef(x,y,0);
		glRotatef(LetterRotation[i],0,1,0);
		glScalef(18,18,1);

		glColor(fillTitleColor,LetterAlphas[i]);
		titlefont->printCenter(LetterStrings[i]);

		glPopMatrix();

		if (OutlineAlphas[i] > 0.0)
		{
			glPushMatrix();
			glTranslatef(x,y,0);
			glRotatef(LetterRotation[i],0,1,0);
			glScalef(18,18,1);

			glColor(outlineTitleColor,OutlineAlphas[i]);
			titleoutline->printCenter(LetterStrings[i]);

			glPopMatrix();
		}

		glPopMatrix();
	}

	glDisable(GL_BLEND);
}

void IntroInformation::LoadData()
{}

void IntroInformation::RegisterModels()
{
	if (!infofont)
		infofont = new GLFont("Arial",NULL,1000.0);
	titlefont = game.font[FNT_TITLE];
	titleoutline = game.font[FNT_TITLE_OUTLINE];
}

void IntroInformation::ReleaseModels()
{
	if (infofont)
	{
		delete infofont;
		infofont = NULL;
	}
}

void IntroInformation::Reset()
{
	titlefont = game.font[FNT_TITLE];
	world = &game.menu.menu_world;

	finished = false;
	currentTime = 0;
	currentEventTime = 0;
	currentEvent = 0;

	currentEvent = ITE_FADEIN;
	
	game.menu.ResetMenuWorld();

	vec3f offset(50,0,100);
	world->tank[1] = world->tank[0];
	world->eyepoint.pos = 	world->tank[1].model.pos + offset;
	world->tank[0].model.pos = world->tank[1].model.pos + UP*100;
	world->eyeTarget = world->tank[1].model.pos + UP*100 + vec3f(25,0,0);
	world->tank[0].active = false;

	world->tank[2] = world->tank[0];
	world->tank[2].SetTankModel(3);

	world->tank[1].hoverStatus = world->tank[2].hoverStatus = HOVER_OFF;

	ZeroMemory(&t2input,sizeof(t2input));

	PerLetterRotationTime = 
		(TotalTitleRotationTime + (NUM_LETTERS-1.0)*LetterActionOverlap)
		/(float)NUM_LETTERS;
	PerOutlineFadeTime = 
		(TotalOutlineFadeTime + (NUM_LETTERS-1.0)*LetterActionOverlap)
		/(float)NUM_LETTERS;

	for (int i=0; i < NUM_LETTERS; i++)
	{
		LetterRotation[i] = 90;
		LetterAlphas[i] = 0.0;
		//LetterRotation[i] = 0;
		//LetterAlphas[i] = 1.0;
		OutlineAlphas[i] = 0.0;

		LetterRotateStartTime[i] = (float)i*TotalTitleRotationTime/(float)NUM_LETTERS;
		OutlineFadeStartTime[i] = TotalTitleRotationTime+(float)i*TotalOutlineFadeTime/(float)NUM_LETTERS;
	}
}

