#pragma once

#define USING_DXINPUT

typedef enum { IE_KB, IE_MOUSE } IEType;

struct InputEvent_type
{
	IEType type;
	unsigned char key;
	int button;
	int state;
	int x, y;
};

struct InputStatus_type
{
	bool left;
	bool right;
	bool thrust;
	bool brake;
	bool fire;
	bool shield;

	float turnAmount;

	bool upkey;
	bool downkey;
	bool selectkey;

	bool chat;
	bool score;
	bool pause;

	bool escKey;

	bool mousebuttons[8];

	int mousex;
	int mousey;
	int mousez;
};

extern struct InputStatus_type input;

// Contains all the relevant info from the InputStatus_type,
// but compacted into as little memory as possible.
#pragma pack( push, 1 )
struct CompactInputStatus_type
{
	unsigned int left   : 1;
	unsigned int right  : 1;
	unsigned int thrust : 1;
	unsigned int brake  : 1;
	unsigned int fire   : 1;
	unsigned int shield : 1;
	unsigned int pause  : 1;
	unsigned int engine : 1;		// engine on/off status;
	unsigned int dir    : 12;		// dir in 10th of degrees
};
#pragma pack( pop )

bool setupInput();
void cleanupInput();
bool keyboardAcquire(bool acquire);
bool mouseAcquire(bool acquire);
void focusChange(bool hasFocus);

void checkInput(void);
void glutKeyboard(unsigned char key, int x, int y);
void glutMouse(int button, int state, int x, int y);

void InitDirectInput();
void ExitDirectInput();

// Some handy status flags
extern bool mouseAcquired;
extern bool keyboardAcquired;
extern bool wantKbAcquire;
extern bool wantMouseAcquire;

