#pragma once

//#include "gameEngine.h"
//#include "world.h"

typedef enum { 
	MESG_SYSTEM_NOTICE, 
	MESG_SYSTEM_ERROR, 
	MESG_GAME_EVENT, 
	MESG_CHAT,
	NUM_HUD_MESG_TYPES
} hudMesgType;

typedef enum { 
	MSGCOL_SYSTEM_NOTICE, 
	MSGCOL_SYSTEM_ERROR, 
	MSGCOL_GAME_EVENT, 
	MSGCOL_CHAT_MSG,
	MSGCOL_CHAT_USER,
	MSGCOL_SCORE_BOARD_TITLE,
	MSGCOL_SCORE_BOARD_GEN,
	MSGCOL_SCORE_BOARD_LOCAL,
	MSGCOL_STATUS_NORMAL,
	MSGCOL_PANEL_BACKGROUND,
	NUM_MSG_COLS
} hudMesgColorID;

struct MessageInfo
{
	hudMesgType type;
	int fromPlayerIdx;
	char msg[MAX_PATH];
};

typedef enum {
	HUD_MESG_PANEL,
	HUD_KILL_PANEL,
	HUD_WEAPON_PANEL,
	HUD_ARMOR_PANEL,
	HUD_SCORE_PANEL,
	HUD_NUM_PANELS,
} PanelID;

#include <deque>

#define MAX_MESG_LEN (MAX_PATH)

class HUD
{
	protected:
		static vec4f panelCoords[HUD_NUM_PANELS];

		timet messagePanelIdle;
		float messageLineScrollAmount;
		float messagePanelAlpha;

		const float hudPanelBaseAlpha;

		const timet messagePanelStaticTimeout;
		const timet messagePanelFadeTime;
		const float messageLineScrollSpeed;
		const int numMessageLines;

		bool m_bEditingTextMessage;
		char m_sWorkingMessage[MAX_MESG_LEN];

		static vec3f messageColor[NUM_MSG_COLS];

	public:
		bool HandleInput(InputEvent_type e);

		deque<MessageInfo> messages;

		WorldInformation* myworld;
		
		HUD() :
				hudPanelBaseAlpha         (0.3),		// in alpha
				messagePanelStaticTimeout (9.0),		// in sec
				messagePanelFadeTime      (1.0),		// in sec
				messageLineScrollSpeed    (3.0),		// in lines/sec (??)
				numMessageLines           (  7)		// in lines
			{ hudFont = NULL; };
		~HUD() { if (hudFont) ReleaseModels(); };

		void Draw();
		void DrawPanel(vec4f coords, float z);

		void DrawScore();
		void DrawMessages();
		void DrawStatus();

		void LoadData();
		void RegisterModels();
		void ReleaseModels();
		void SetWorld(WorldInformation* world);
		void AddMessage(hudMesgType type, int playerIdx, char* msg);
		void update(timet dtime);

		void StartEditingMessage();
		bool IsEditingMessage() { return m_bEditingTextMessage; };

		GLFont* hudFont;
};

