#include "global.h"

//GLFont* font;

// I don't yet have a better home for this guy
double frand(void)
{
	return (double)rand() / (double)RAND_MAX;
}

void initGL(void)
{
	glPixelStorei(GL_UNPACK_ALIGNMENT,1);

	glClearColor(0.0, 0.0, 0.0, 0.0);
	glShadeModel(GL_SMOOTH);
	//glEnable(GL_COLOR_MATERIAL);
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);

	//glEnable(GL_RESCALE_NORMAL);

	GLFont loadingfont("Arial");
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluOrtho2D(0,100,0,100);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	loadingfont.setScale(5,5,0);
	loadingfont.printxyzCenter(50,50,0,"Loading and registering data...");

	glutarSwapBuffers();

	game.RegisterModels();

	glCullFace(GL_BACK);

	//font = new GLFont("GlaserSted");
}

float renderTime;
#ifdef HT_SERVER
#define timerfreq timerfreq_server
#endif
extern LARGE_INTEGER timerfreq;

void display(void)
{
	LARGE_INTEGER renderStart, renderFinish;
	QueryPerformanceCounter(&renderStart);

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	game.Draw();

	QueryPerformanceCounter(&renderFinish);
	renderTime = (renderFinish.QuadPart-renderStart.QuadPart)/(float)timerfreq.QuadPart;

	glutarSwapBuffers();
}

void reshape(int w, int h)
{
	glViewport( 0, 0, (GLsizei) w, (GLsizei) h);
	game.config.aspect = (GLfloat)w/(GLfloat)h;
}

