#pragma once

#include "HTNetServer.h"
#include "hud.h"

typedef enum { GS_INIT, GS_INTRO, GS_MENU, GS_PLAYING } GameState;
typedef enum { FNT_TITLE, FNT_TITLE_OUTLINE, FNT_MENU1, FNT_MENU2, FNT_NUM_FONTS } FontID;

struct FreqPerBitDepth {	DWORD freq;	};
typedef deque<FreqPerBitDepth> FreqPerBitDepthSet;
struct BitDepthPerResolution
{
	DWORD bitdepth;
	FreqPerBitDepthSet freq;
};
typedef deque<BitDepthPerResolution> BitDepthPerResolutionSet;
struct ScreenResolution
{
	DWORD width;
	DWORD height;
	BitDepthPerResolutionSet bitdepth;
};
typedef vector<ScreenResolution> VideoModeList;

struct GameConfig
{
	float aspect;
	VideoModeList availableModes;

	int chosenVideoMode;
	int chosenBitdepth;
	int chosenFreq;

	bool fullScreen;

	int windowedWidth;
	int windowedHeight;
};

class GameInformation
{
	public:
		bool showingInGameMenu;
		int currentGameSong;

		bool wantMusic;

		void NextGameSong();
		void PrevGameSong();
		void StopMusic();
		void PlayMusic();

		void error(char* fmt, ...);
		GameInformation() { state = GS_INIT; }
		~GameInformation()
		{
			// Ack!  This needs to be done _after_ all the objects with COM stuff die out.
			// Maybe in the game Constructor/Destructor?  To be a good citizen?  Not sure.
			// Or be better about cleaning up in my network objects... *sigh*
			CoUninitialize();
		}
		GameState state;
		WorldInformation world;
		IntroInformation intro;
		MenuInformation menu;
		HUD hud;

		HTNetClient netclient;
		HTNetServer netserver;

		GLFont* font[FNT_NUM_FONTS];
		void ReleaseModels();
		bool RegisterModels();
		void update(timet dtime);
		void Draw();
		bool LoadData();
		void SetState(GameState newState);
		void Initialize();
		void GetDisplayModeInfo();
		bool HandleInput(InputEvent_type e);

		bool SetVideoMode(int vmIdx, int bdIdx, int fIdx, bool fullscreen, 
			int width=-1, int height=-1);

		GameConfig config;
};

extern GameInformation game;

// May be re-declared in game.h, but that's ok -- same definition
bool isKeyboardAcquired();
bool isMouseAcquired();

