(* mouse.ml: implementation file for handling the mouse for the game. *)

open Tk

(* Cause the pointer to be grabbed by the Tk root window (and vanishes) *)
external grabmouse: unit -> unit = "grabmouse"

(* Warp the pointer to the given coordinates, relative to the Tk root window *)
external warpmouse: int -> int -> unit = "warpmouse"

(* Release the pointer (ungrab it) (and make it reappear) *)
external releasemouse: unit -> unit = "releasemouse"


(* Hides the mouse cursor, restrains it to the Tk root window, and won't let it
 * move out. The callback receives mouse events as deltax, deltay, button
 * status. *)
let game_mode_on ~poscb ~butcb =
  grabmouse ();
  let top = Widget.default_toplevel in
  let cx = (Winfo.width top)/2 in
  let cy = (Winfo.height top)/2 in
  warpmouse cx cy;
  bind ~events:[`Motion] ~fields:[`MouseX; `MouseY] ~action:
    (fun evinf ->
      if (evinf.ev_MouseX <> cx) || (evinf.ev_MouseY <> cy) then begin
        poscb (evinf.ev_MouseX - cx) (evinf.ev_MouseY - cy);
        warpmouse cx cy
      end else ()) top;
  bind ~events:[`ButtonPress] ~action:(fun evinf -> butcb ()) top


(* Turns game mode off: the pointer reappears and is no longer restrained, and
 * the callback registered before is no longer active. *)
let game_mode_off () =
  releasemouse ();
  let top = Widget.default_toplevel in
  bind ~events:[`Motion] ~action:(fun evinf -> ()) top;
  bind ~events:[`ButtonPress] ~action:(fun evinf -> ()) top;

