(* game.mli: interface for general game events *)

type state = {
  mutable prevtime: float;
  mutable spiff: Spiff.t;
  mutable lev: int;
  mutable dungeon: Level.t array;
}

type result = StillPlaying | WonGame | LostGame | LostChance | NextLevel

(* given the ToGL widget the game will be played in, initialize all the
 * objects for rendering. *)
val init: Togl.widget -> unit

(* attempt to load a new game in from the level files *)
val load_newgame: unit -> state

(* called when gameplay resumes, in order to make sure the game time is
 * correct. *)
val resumeplaying: state -> unit

(* restarts the game at level 0 *)
val restart: state -> unit

(* called every time step to advance the state of the game. *)
val update: state -> result

(* render the current state s of the game in given ToGL widget, with flags
 * for lighting, texture and stereo mode. *)
val render: state -> Togl.widget -> bool -> bool -> bool -> unit

(* attempts to activate dematterizer *)
val pressbutton: state -> unit -> unit

