(* freeobj.mli: interface for free objects *)

(* There are two types of free objects in the game: *)
type kind = Charge  | Bribe | Teleporter

type t = {
  kind: kind;
  hull: Collision.hull;
  mutable vy: float; (* free objects can fall, but they don't move in x or z *)
  mutable dmtimer: float;
}

(* create a new fre object at given position *)
val newfree: kind -> float -> float -> float -> t

(* initialize stuff - should be called before render *)
val init: unit -> unit

(* update the free object given delta_t and a list of objects that it might
 * collide with. *)
val update: t -> float -> Collision.hull list -> unit

(* return the hull-action pair for the given free object *)
val actionpair: t -> (Collision.hull * Collision.action)

(* render the free object, with flags for textures and greyscale mode *)
val render: t -> bool -> bool -> unit
