(* collision.mli: interface for axis-aligned bounding box collision detection
 * and response *)

type hull = {
  mutable x: float;   (* position of center of axis-aligned box *)
  mutable y: float;
  mutable z: float;
  lx: float;          (* half side lengths *)
  ly: float;
  lz: float
}


(* actions that may result from a collision *)
type action = DoNothing | Teleport | LoseChance | TeleCharge | GetBribe
            | LoseGame


(* Given two objects return how far above the first is above the other, within
 * the given tolerance. Positive values indicate no collision, and shouldn't
 * be trusted as valid heights. *)
val topcollision: hull -> hull -> float -> float


(* Given two objects return whether they are in collision. *)
val incollision: hull -> hull -> bool


(* Given a hull, a proposed movement, and a list of possibly colliding hulls
 * (that aren't in collision before the movement), return a deflection of that
 * movement that avoids collision.
 *)
val deflect: hull -> float -> float -> float -> hull list ->
             (float * float * float)

