(* badguy.mli: interface for handling badguys *)

type kind = Guard

type t = {
  kind: kind;
  hull: Collision.hull;
  mutable gait: float;
  mutable vx: float;
  mutable vy: float;
  mutable vz: float;
  mutable heading: float;
  mutable triedjump: bool;

  (* initial position in level *)
  initx: float;
  inity: float;
  initz: float;
  initheading:float;
}

(* return a new badguy with given kind and initial stuff *)
val newbadguy: kind -> float -> float -> float -> float -> t

(* initialize stuff before rendering *)
val init: unit -> unit

(* update the given bad guy by the time increment, given nearby collision
 * hulls to avoid and the Spiff/badguy scents in the surrounding 3x1x3 cubes *)
val update: t -> float -> Collision.hull list -> float array -> unit

(* return the hull-action pair for the given badguy *)
val actionpair: t -> (Collision.hull * Collision.action)

(* render the bad guy (flags for texture and greyscale mode) *)
val render: t -> bool -> bool -> unit

