// note for cs248-08
// files provided by Andrew Adams for cs248-06

// Compile on cygwin:
// /usr/bin/g++ Shader.cpp `sdl-config --cflags --libs` -I/usr/include -lglew32 -lopengl32 -lglu32
// Compile on myths:
// /usr/bin/g++ Shader.cpp `/usr/bin/sdl-config --cflags --libs` -lGL -lGLU

#include <stdlib.h>

#include <GL/gl.h>
#include <GL/glu.h>
#include <SDL.h>

class World {
private:
    float theta;
    GLuint textureId;

public:
    World() {
	theta = 0;

	glGenTextures(1, &textureId);

	SDL_Surface *texture = SDL_LoadBMP("texture.bmp");
	glBindTexture(GL_TEXTURE_2D, textureId);

	gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGB, 
			  texture->w, texture->h,
			  GL_BGR, GL_UNSIGNED_BYTE, 
			  texture->pixels);

	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, 
			GL_LINEAR);

	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, 
			GL_LINEAR_MIPMAP_LINEAR);

	SDL_FreeSurface(texture);
    }

    void draw() {
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glLoadIdentity();
	glRotatef(theta, 3, 2, 1);



        glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, textureId);

	glBegin(GL_QUADS);
	glColor3f(1, 1, 1);
	glNormal3f( 0,  0,  1);

	glTexCoord2f(0, 1);
	glVertex3f(-1, -1,  1);

        glTexCoord2f(1, 1);
	glVertex3f( 1, -1,  1);

	glTexCoord2f(1, 0);
	glVertex3f( 1,  1,  1);

	glTexCoord2f(0, 0);
	glVertex3f(-1,  1,  1);
        glEnd();

        glDisable(GL_TEXTURE_2D);
        glBegin(GL_QUADS);
	glColor3f(0.4, 0.4, 1);
	glNormal3f( 0,  0, -1);
	glVertex3f(-1, -1, -1);
	glVertex3f(-1,  1, -1);
	glVertex3f( 1,  1, -1);
	glVertex3f( 1, -1, -1);

	glColor3f(0.4, 1.0, 0.4);
	glNormal3f( 1,  0,  0);
	glVertex3f( 1, -1, -1);
	glVertex3f( 1,  1, -1);
	glVertex3f( 1,  1,  1);
	glVertex3f( 1, -1,  1);

	glNormal3f(-1,  0,  0);
	glVertex3f(-1, -1, -1);
	glVertex3f(-1,  1, -1);
	glVertex3f(-1,  1,  1);
	glVertex3f(-1, -1,  1);

	glColor3f(1.0, 0.4, 0.4);
	glNormal3f( 0,  1,  0);
	glVertex3f(-1,  1, -1);
	glVertex3f(-1,  1,  1);
	glVertex3f( 1,  1,  1);
	glVertex3f( 1,  1, -1);

	glNormal3f( 0, -1,  0);
	glVertex3f(-1, -1, -1);
	glVertex3f(-1, -1,  1);
	glVertex3f( 1, -1,  1);
	glVertex3f( 1, -1, -1);
	glEnd();
	
    }

    void update() {
	theta ++;
    }

    void handleEvents() {
	SDL_Event event;
	while (SDL_PollEvent(&event)) {
	    switch (event.type) {

	    case SDL_QUIT:
		SDL_Quit();
		exit(0);
		break;

	    case SDL_KEYDOWN:
		switch (event.key.keysym.sym) {
		case SDLK_ESCAPE:
		    SDL_Quit();
		    exit(0);
		    break;
		default:
		    theta += 10;
		    break;
		}
		
		break;

	    default:
		break;
	    }
	}

    }
};



int main(int argc, char **argv) {
    SDL_Init(SDL_INIT_VIDEO);
    
    int flags = SDL_OPENGL | SDL_GL_DOUBLEBUFFER;

    SDL_SetVideoMode(800, 600, 32, flags);

    glViewport(0, 0, 800, 600);

    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluPerspective(45, 4.0/3, 0.1, 100);
    gluLookAt(0, 0, 5,
	      0, 0, 0,
	      0, 1, 0);

    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();

    glEnable(GL_DEPTH_TEST);
    glEnable(GL_LIGHTING);
    glEnable(GL_LIGHT0);
    glEnable(GL_COLOR_MATERIAL);
    glEnable(GL_TEXTURE_2D);

    GLfloat position[4] = {2, 2, 5, 1};
    GLfloat color[4] = {1, 1, 1, 1};
    glLightfv(GL_LIGHT0, GL_POSITION, position);
    glLightfv(GL_LIGHT0, GL_DIFFUSE, color);

    World world;

    while (1) {
	world.handleEvents();
	world.update();
	world.draw();

	SDL_GL_SwapBuffers();	
	SDL_Delay(30);
    }

}
