#include <stdio.h>
#include <stdlib.h>
#include <GL/glut.h>

#define LIGHT 0

float lpos[4] = {1,0.5,1,0};
float xpos = 0;
float ypos = 0;

void processKeys(unsigned char key, int x, int y)
{
	if (key == 'w')
		ypos += .1f;
	else if (key == 's')
		ypos -= .1f;
	if (key == 'd')
		xpos += .1f;
	else if (key == 'a')
		xpos -= .1f;	
}

void processMouse(int button, int state, int x, int y)
{
	printf("mouse %d at %d %d\n", button, x, y);
}

void motionMouse(int x, int y)
{
}

void glInit()
{
	glClearColor(1.0,1.0,1.0,1.0);
#if LIGHT
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
#endif
	//glShadeModel(GL_FLAT);
#if 0
	glEnable(GL_DEPTH_TEST);
#endif
#if 0
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
#endif
}

void changeSize(int w, int h) {
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
    glViewport(0, 0, w, h);
#if 0
	gluPerspective(45,w/h,1,1000);
#else
	glOrtho(-3, 3, -3, 3, .01, 50);
#endif
	glMatrixMode(GL_MODELVIEW);
}

void renderScene(void) {
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glLoadIdentity();
	gluLookAt(0.0,0.0,5.0, 0.0,0.0,-1.0, 0.0f,1.0f,0.0f);
	glTranslatef(xpos,ypos, 0);
#if LIGHT
	glLightfv(GL_LIGHT0, GL_POSITION, lpos);
#endif
#if 0
	//glutSolidTeapot(1);
#else
	glBegin(GL_TRIANGLES);

	glColor3f(1,0,0);
	glColor4f(1,0,0, .5f);
	glVertex3f(0,0,0);
	glVertex3f(2,0,0);
	glVertex3f(0,2,0);
	
	glColor3f(0,0,1);
	glVertex3f(0,0,-5);
	glVertex3f(2,0,-5);
	glVertex3f(0,2,-5);

	glEnd();
#endif
	glutSwapBuffers();
}

int main(int argc, char **argv) {
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_DEPTH | GLUT_DOUBLE | GLUT_RGBA);
	glutInitWindowPosition(100,100);
	glutInitWindowSize(500,500);
	glutCreateWindow("CS248 is Great");

	glutDisplayFunc(renderScene);
	glutIdleFunc(renderScene);
	glutReshapeFunc(changeSize);
	glutKeyboardFunc(processKeys);
	glutMouseFunc(processMouse);
	glutMotionFunc(motionMouse);

	glInit();

	glutMainLoop();
	return 0;
}
