// simplified and modified version of demo from www.lighthouse3d.com

#include <stdio.h>
#include <stdlib.h>
#include <GL/glew.h>
#include <GL/glut.h>

GLhandleARB v,f,p;
float lpos[4] = {1,0.5,1,0};

const char * ff = 
"varying vec3 normal, lightDir;\
void main()\
{\
	float intensity;\
	vec3 n;\
	vec4 color;\
	n = normalize(normal);\
	intensity = max(dot(lightDir,n),0.0); \
	gl_FragColor = color;\
	if (intensity > 0.98) color = vec4(0.8,0.8,0.8,1.0);\
	else if (intensity > 0.5) color = vec4(0.4,0.4,0.8,1.0);\
	else if (intensity > 0.25) color = vec4(0.2,0.2,0.4,1.0); \
	else color = vec4(0.1,0.1,0.1,1.0); \
	gl_FragColor = color; \
}\
";

const char * vv = 
"	varying vec3 normal, lightDir;\
	void main() {\
	lightDir = normalize(vec3(gl_LightSource[0].position));\
	normal = normalize(gl_NormalMatrix * gl_Normal);\
	gl_Position = ftransform();\
}\
";

void changeSize(int w, int h) {
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
    glViewport(0, 0, w, h);
	gluPerspective(45,w/h,1,1000);
	glMatrixMode(GL_MODELVIEW);
}

void renderScene(void) {
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glLoadIdentity();
	gluLookAt(0.0,0.0,5.0, 0.0,0.0,-1.0, 0.0f,1.0f,0.0f);
	glLightfv(GL_LIGHT0, GL_POSITION, lpos);
	glutSolidTeapot(1);
	glutSwapBuffers();
}

void setShaders() {
	v = glCreateShaderObjectARB(GL_VERTEX_SHADER_ARB);
	f = glCreateShaderObjectARB(GL_FRAGMENT_SHADER_ARB);

	glShaderSourceARB(v, 1, &vv,NULL);
	glShaderSourceARB(f, 1, &ff,NULL);

	glCompileShaderARB(v);
	glCompileShaderARB(f);

	p = glCreateProgramObjectARB();
	glAttachObjectARB(p,f);
	glAttachObjectARB(p,v);

	glLinkProgramARB(p);
	glUseProgramObjectARB(p);
}



int main(int argc, char **argv) {
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_DEPTH | GLUT_DOUBLE | GLUT_RGBA);
	glutInitWindowPosition(100,100);
	glutInitWindowSize(320,320);
	glutCreateWindow("GLSL test");

	glutDisplayFunc(renderScene);
	glutIdleFunc(renderScene);
	glutReshapeFunc(changeSize);

	glEnable(GL_DEPTH_TEST);
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	glClearColor(1.0,1.0,1.0,1.0);

	glewInit();
	if (GLEW_ARB_vertex_shader && GLEW_ARB_fragment_shader)
		printf("Ready for GLSL\n");
	else {
		printf("No GLSL support\n");
		exit(1);
	}

	//setShaders();
	glutMainLoop();
	return 0;
}
