varying vec2 texCoord;
varying vec4 color;
varying float depth;

void main() {
    vec3 normal, lightDir;
    vec4 position, diffuse;
    float NdotL;

    normal = normalize(gl_NormalMatrix * gl_Normal);

    position = gl_ModelViewMatrix * gl_Vertex;     

    lightDir = normalize(vec3(gl_LightSource[0].position - position));

    NdotL = max(dot(normal, lightDir), 0.2);

    diffuse = gl_Color * gl_LightSource[0].diffuse;

    color = NdotL * diffuse;
    color.w = 1.0;    

    gl_Position = gl_ProjectionMatrix * position;

    texCoord = vec2(gl_MultiTexCoord0);
    depth = gl_Position.z;  
}

