
from OpenGL.GL import *

def create(width, height):

    global program

    fragsource = """

    uniform sampler2D tex;

    vec4 sample(float x, float y) {
        return texture2DLod(tex, gl_TexCoord[0].xy + vec2(x/%f, y/%f), 0.0);
    }
    
    void main(void) {
        vec4 col = vec4(0.0, 0.0, 0.0, 0.0);
        float x, y;
        for (x = -2.0; x <= 2.0; x++) {
            for (y = -2.0; y <= 2.0; y++) {
                col += sample(5.0*x, 5.0*y);
            }
        }
        gl_FragColor = sample(0.0, 0.0) + 3.0*(sample(0.0, 0.0) + col/25.0);
    }
    
    """ % (width, height)

    fragshader = glCreateShader(GL_FRAGMENT_SHADER)
    glShaderSource(fragshader, [fragsource])
    glCompileShader(fragshader)    

    program = glCreateProgram()
    glAttachShader(program, fragshader)
    glLinkProgram(program)

    glFlush()

          
def enable():
    global program
    glUseProgram(program)
    glFlush()
          
def disable():
    glUseProgram(0)
    glFlush()


