
from OpenGL.GL import *
from glew import *

def create(width, height):

    global program

    glewInit()
    glewGetExtension("GL_ARB_fragment_shader")
    glewGetExtension("GL_ARB_shader_objects")
    glewGetExtension("GL_ARB_shading_language_100")

    fragsource = """

    sampler2D tex;

    vec4 sample(float x, float y) {
        return texture2DLod(tex, gl_TexCoord[0].xy + vec2(x/%f, y/%f), 10.0);
    }
    
    void main(void) {
        vec4 col = vec4(0, 0, 0, 0);
        float x, y;
        for (x = -2; x <= 2; x++) {
            for (y = -2; y <= 2; y++) {
                col += sample(5*x, 5*y);
            }
        }
        gl_FragColor = sample(0, 0) + 3*(sample(0, 0) - col/25);
    }
    
    """ % (width, height)

    fragshader = glCreateShaderObjectARB(GL_FRAGMENT_SHADER_ARB)
    glFlush()
    glShaderSourceARB(fragshader, 1, [fragsource])
    glFlush()
    
    glCompileShaderARB(fragshader)
    glGetObjectParameterivARB(fragshader, GL_OBJECT_COMPILE_STATUS_ARB)
    print glGetInfoLogARB(fragshader)
    
    program = glCreateProgramObjectARB()
    glFlush()

    glAttachObjectARB(program, fragshader)
    glFlush()

    glLinkProgramARB(program)
    glFlush()

    print glGetInfoLogARB(program)
    glFlush()

          
def enable():
    global program
    glUseProgramObjectARB(program)
    glFlush()
          
def disable():
    glUseProgramObjectARB(0)
    glFlush()


