from OpenGL.GL import *
from pygame.locals import *
from math import *
import array
import pygame
import time
import sys
from random import random

X = 600
Y = 600

def init():    
    global texID

    pygame.init()    
    pygame.display.set_mode((X, Y), DOUBLEBUF | OPENGL)

    # make a texture for the framebuffer
    glEnable(GL_TEXTURE_2D)
    texID = glGenTextures(1)
    data = '\0' * X * Y * 4
    glBindTexture(GL_TEXTURE_2D, texID)
    glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, X, Y, 0,
                 GL_RGBA, GL_UNSIGNED_BYTE, data)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP)
    #glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_R, GL_CLAMP)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP)
                    

def jitter(): return (random()*2 - 1) * 0.01

theta = 0

def draw():
    global theta
    theta += 1

    # draw the texture
    glEnable(GL_TEXTURE_2D)
    glBindTexture(GL_TEXTURE_2D, texID)
    glColor(1, 0.90, 0.90)
    glScale(1.02, 1.02, 1.02)
    glBegin(GL_QUADS)
    glVertex3f(-1.0, -1.0, 0); glTexCoord2i(1, 0)
    glVertex3f(1.0, -1.0, 0);  glTexCoord2i(1, 1)
    glVertex3f(1.0, 1.0, 0);   glTexCoord2i(0, 1)
    glVertex3f(-1.0, 1.0, 0);  glTexCoord2i(0, 0)
    glEnd()


    # draw a square
    glDisable(GL_TEXTURE_2D)
    glColor3f(1, 0.5, 0.5)
    glPushMatrix()

    glRotate(theta, 0, 0, 1)
    glTranslate(0.4, 0, 0)
    glRotate(theta, 0, 0, 1)
    glColor3f(0.7, 0.7, 1.0)
    glBegin(GL_QUADS)
    glVertex3f(-0.2, 0.2, 0)
    glVertex3f(-0.2, -0.2, 0)
    glVertex3f(0.2, -0.2, 0)
    glVertex3f(0.2, 0.2, 0)
    glEnd()

    glPopMatrix()
    
    # copy it into a texture
    glBindTexture(GL_TEXTURE_2D, texID)
    glCopyTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, 0, 0, X, Y, 0)

def mainloop():
    glClearColor(0, 0, 0, 1)
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)

    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()

    draw()
    
    for ev in pygame.event.get():
        if ev.type == QUIT: sys.exit()
        
    pygame.display.flip()


if __name__ == '__main__':
    init()
    while 1:
        mainloop()
        time.sleep(0.001)
