from OpenGL.GL import *

def create(width, height):

    global program

    fragsource = """
    uniform sampler2D tex;

    float sample(float x, float y) {
    return step(0.99, texture2DLod(tex, gl_TexCoord[0].xy + vec2(x/%f, y/%f), 100.0).x);
    }
    
    void main(void) {
    float sum = (sample(0.0, 0.0)*0.5 + sample(0.0, -1.0) + sample(0.0, 1.0) +
                 sample(-1.0, 0.0) + sample(-1.0, -1.0) + sample(-1.0, 1.0) +
                 sample(1.0, 0.0) + sample(1.0, -1.0) + sample(1.0, 1.0));

    if (sum < 2.25 || sum > 3.75) gl_FragColor = texture2DLod(tex, gl_TexCoord[0].xy, 100.0) * 0.9;
    else gl_FragColor = gl_Color;
    }
    
    """ % (width, height)

    fragshader = glCreateShader(GL_FRAGMENT_SHADER)
    glFlush()
    glShaderSource(fragshader, [fragsource])
    glFlush()
    
    glCompileShader(fragshader)
    #glGetParameteriv(fragshader, GL_OBJECT_COMPILE_STATUS_)
    #print glGetInfoLog(fragshader)
    
    program = glCreateProgram()
    glFlush()

    glAttachShader(program, fragshader)
    glFlush()

    glLinkProgram(program)
    glFlush()

    #print glGetInfoLog(program)
    glFlush()

          
def enable():
    global program
    glUseProgram(program)
    glFlush()
          
def disable():
    glUseProgram(0)
    glFlush()


