
from OpenGL.GL import *
from glew import *

def create(width, height):

    global program

    glewInit()
    glewGetExtension("GL_ARB_fragment_shader")
    glewGetExtension("GL_ARB_shader_objects")
    glewGetExtension("GL_ARB_shading_language_100")

    fragsource = """
    sampler2D tex;

    float sample(float x, float y) {
    return step(0.99, texture2DLod(tex, gl_TexCoord[0].xy + vec2(x/%f, y/%f), 100.0).x);
    }
    
    void main(void) {
    float sum = (sample(0.0, 0.0)*0.5 + sample(0.0, -1.0) + sample(0.0, 1.0) +
                 sample(-1.0, 0.0) + sample(-1.0, -1.0) + sample(-1.0, 1.0) +
                 sample(1.0, 0.0) + sample(1.0, -1.0) + sample(1.0, 1.0));

    if (sum < 2.25 || sum > 3.75) gl_FragColor = texture2DLod(tex, gl_TexCoord[0].xy, 100.0) * 0.9;
    else gl_FragColor = gl_Color;
    }
    
    """ % (width, height)

    fragshader = glCreateShaderObjectARB(GL_FRAGMENT_SHADER_ARB)
    glFlush()
    glShaderSourceARB(fragshader, 1, [fragsource])
    glFlush()
    
    glCompileShaderARB(fragshader)
    glGetObjectParameterivARB(fragshader, GL_OBJECT_COMPILE_STATUS_ARB)
    print glGetInfoLogARB(fragshader)
    
    program = glCreateProgramObjectARB()
    glFlush()

    glAttachObjectARB(program, fragshader)
    glFlush()

    glLinkProgramARB(program)
    glFlush()

    print glGetInfoLogARB(program)
    glFlush()

          
def enable():
    global program
    glUseProgramObjectARB(program)
    glFlush()
          
def disable():
    glUseProgramObjectARB(0)
    glFlush()


