from OpenGL.GL import *
from pygame.locals import *
from math import *
#import shader
import shader30 as shader # For PyOpenGL3.0
import array
import pygame
import time
import sys
from random import random

X = 700
Y = 700

def init():    
    global texID

    pygame.init()    
    pygame.display.set_mode((X, Y), DOUBLEBUF | OPENGL)
    shader.create(X, Y)

    # make a texture for the framebuffer
    glEnable(GL_TEXTURE_2D)
    texID = glGenTextures(1)
    data = '\0' * X * Y * 4
    glBindTexture(GL_TEXTURE_2D, texID)
    glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, X, Y, 0, GL_RGBA, GL_UNSIGNED_BYTE, data)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP)
    #glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_R, GL_CLAMP)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP)
                    

iteration = 0

def draw():
    global vx, vy, x, y, theta, iteration
    iteration += 1

    #glDisable(GL_LINE_SMOOTH)
    #glDisable(GL_BLEND)
    #glHint(GL_LINE_SMOOTH_HINT, GL_FASTEST);
    glEnable(GL_BLEND)
    glBlendFunc(GL_SRC_ALPHA, GL_ONE)
    glDisable(GL_DEPTH_TEST)

    glEnable(GL_TEXTURE_2D)
    glBindTexture(GL_TEXTURE_2D, texID)

    # draw the texture
    shader.enable()
    glBegin(GL_QUADS)
    glColor4f(1, 1, 1, 1)
    glVertex3f(-1, -1, 0); glTexCoord2f(1, 0)
    glVertex3f(1, -1, 0);  glTexCoord2f(1, 1)
    glVertex3f(1, 1, 0);   glTexCoord2f(0, 1)
    glVertex3f(-1, 1, 0);  glTexCoord2f(0, 0)
    glEnd()
    shader.disable()

    # draw the last frame as a background
    glBindTexture(GL_TEXTURE_2D, texID)
    glPushMatrix()
    glRotatef(sin(iteration/100.0)*5+10, 0, 0, 1)
    glScale(sin(iteration/40.0)*0.01 + 1, cos(iteration/30.0)*0.01 + 1, 1)
    glBegin(GL_QUADS)
    glColor4f(0.5, 0.75 + cos(iteration/20.0)*0.25, 0.75 + sin(iteration/24.0)*0.25, 0.3)
    glVertex3f(-0.95, -0.95, 1); glTexCoord2f(1, 0)
    glVertex3f(0.95, -0.95, 1);  glTexCoord2f(1, 1)
    glVertex3f(0.95, 0.95, 1);   glTexCoord2f(0, 1)
    glVertex3f(-0.95, 0.95, 1);  glTexCoord2f(0, 0)
    glEnd()
    glPopMatrix()

    # draw a seed line
    if iteration < 500:
        glDisable(GL_TEXTURE_2D)
        glColor4f(1, 1, 1, 1)
        glBegin(GL_LINES)
        glVertex2f(0.8, 0.001)
        glVertex2f(-0.8, 0.001)
        glVertex2f(0.001, 0.8)
        glVertex2f(0.001, -0.8)
        glEnd()

    # draw a border
    glColor4f(0, 0, 0, 1)
    glBegin(GL_LINE_STRIP)
    glVertex2f(-0.999, -0.999)
    glVertex2f(0.999, -0.999)
    glVertex2f(0.999, 0.999)
    glVertex2f(-0.999, 0.999)
    glVertex2f(-0.999, -0.999)
    glEnd()
    
    # copy it into a texture
    glBindTexture(GL_TEXTURE_2D, texID)
    glCopyTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, 0, 0, X, Y, 0)





def mainloop():
    glClearColor(0, 0, 0, 1)
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)

    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()

    draw()
    
    for ev in pygame.event.get():
        if ev.type == QUIT: sys.exit()
        
    pygame.display.flip()


if __name__ == '__main__':
    init()
    while 1:
        mainloop()
        time.sleep(0.0005)
