# PyOpenGL 3.0b2 version, no GLEW needed
from OpenGL.GL import *
from ctypes import *

def create(width, height):

    global program

    fragsource = """
    uniform sampler2D tex;

    vec4 sample(float x, float y) {
        return texture2DLod(tex, gl_TexCoord[0].xy + vec2(x*%f, y*%f), 0.0);
    }
    
    void main(void) {
        gl_FragColor = gl_Color * (sample(0.0, 0.0) + sample(0.0, 1.0) +
                                   sample(0.0, -1.0) + sample(1.0, 0.0) +
                                   sample(-1.0, 0.0))/5.15;
    }
    
    """ % (1.0/width, 1.0/height)

    fragshader = glCreateShader(GL_FRAGMENT_SHADER)
    glFlush()
    glShaderSource(fragshader, [fragsource]) # The only code modification from GLEW version - one less parameter
    glFlush()
    
    glCompileShader(fragshader)
    length = c_int(1024)
    log = create_string_buffer(1024)
    glGetShaderInfoLog(fragshader, length, byref(length), log)
    print log.value

    
    program = glCreateProgram()
    glAttachShader(program, fragshader)
    glLinkProgram(program)
    #print glGetInfoLog(program)

    glFlush()

          
def enable():
    global program
    assert glIsProgram(program)
    glUseProgram(program)
    glFlush()
          
def disable():
    glUseProgram(0)
    glFlush()


