from OpenGL.GL import *
from pygame.locals import *
from math import *
#import shader
import shader30 as shader
import array
import pygame
import time
import sys
from random import random

X = 500
Y = 500

def init():    
    global texID1, texID2

    pygame.init()    
    pygame.display.set_mode((X, Y), DOUBLEBUF | OPENGL)
    shader.create(X, Y)

    # make a texture for the framebuffer
    glEnable(GL_TEXTURE_2D)
    texID1 = glGenTextures(1)
    data = '\0' * X * Y * 4
    glBindTexture(GL_TEXTURE_2D, texID1)
    glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, X, Y, 0, GL_RGBA, GL_UNSIGNED_BYTE, data)
    glTexParameteri(GL_TEXTURE_2D, GL_GENERATE_MIPMAP, GL_TRUE)

    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP)

    texID2 = glGenTextures(1)
    data = '\0' * X * Y * 4
    glBindTexture(GL_TEXTURE_2D, texID2)
    glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, X, Y, 0, GL_RGBA, GL_UNSIGNED_BYTE, data)
    glTexParameteri(GL_TEXTURE_2D, GL_GENERATE_MIPMAP, GL_TRUE)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP)
                    

iteration = 0

def draw():
    global iteration

    iteration += 1

    # draw the texture

    glEnable(GL_BLEND)
    glDisable(GL_DEPTH_TEST)

    glEnable(GL_TEXTURE_2D)
    glBindTexture(GL_TEXTURE_2D, texID1)

    glBlendFunc(GL_SRC_ALPHA, GL_ONE)
    glColor3f(1, 0.97, 1)
    glPushMatrix()
    glTranslate(0, -0.6, 0)
    glRotate(sin(iteration/200.0)*5, 0, 0, 1)
    glScale(0.8, 0.8, 0.8)
    glTranslate(0, 1, 0)
    glBegin(GL_QUADS)
    glVertex2f(-1, -1); glTexCoord2i(1, 0)
    glVertex2f(1, -1);  glTexCoord2i(1, 1)
    glVertex2f(1, 1);   glTexCoord2i(0, 1)
    glVertex2f(-1, 1);   glTexCoord2i(0, 0)
    glEnd()
    glPopMatrix()

    glPushMatrix()
    glTranslate(0, -0.7, 0)
    glRotate(85 + sin(iteration/240.0)*10, 0, 0, 1)
    glScale(-0.4, 0.4, 1)
    glTranslate(0, 1, 0)
    glBegin(GL_QUADS)
    glVertex2f(-1, -1); glTexCoord2i(1, 0)
    glVertex2f(1, -1);  glTexCoord2i(1, 1)
    glVertex2f(1, 1);   glTexCoord2i(0, 1)
    glVertex2f(-1, 1);   glTexCoord2i(0, 0)
    glEnd()
    glPopMatrix()

    glPushMatrix()
    glTranslate(0, -0.8, 0)
    glRotate(-85 + sin(iteration/220.0)*10, 0, 0, 1)
    glScale(0.4, 0.4, 1)
    glTranslate(0, 1, 0)
    glBegin(GL_QUADS)
    glVertex2f(-1, -1); glTexCoord2i(1, 0)
    glVertex2f(1, -1);  glTexCoord2i(1, 1)
    glVertex2f(1, 1);   glTexCoord2i(0, 1)
    glVertex2f(-1, 1);   glTexCoord2i(0, 0)
    glEnd()
    glPopMatrix()

    # draw something
    glDisable(GL_TEXTURE_2D)
    glColor3f(0.3 + 0.3*cos(iteration/350.0),
              1.0, 0.3 + 0.3*sin(iteration/300.0))
    glBegin(GL_QUADS)

    glVertex2f(0.01, -1)
    glVertex2f(-0.01, -1)
    glVertex2f(-0.01, -0.6)
    glVertex2f(0.01, -0.6)    
    glEnd()
    
    # copy it into a texture
    glBindTexture(GL_TEXTURE_2D, texID1)
    glCopyTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, 0, 0, X, Y, 0)

    # draw some special effects
    glEnable(GL_TEXTURE_2D)
    glBindTexture(GL_TEXTURE_2D, texID2)
    shader.enable()
    glColor3f(0.95, 0.95, 0.95)

    s = 1.01 + 0.001 * sin(iteration/20.0)

    glBegin(GL_QUADS)
    glVertex2f(-s, -s); glTexCoord2i(1, 0)
    glVertex2f(s, -s);  glTexCoord2i(1, 1)
    glVertex2f(s, s);   glTexCoord2i(0, 1)
    glVertex2f(-s, s);   glTexCoord2i(0, 0)
    glEnd()
    shader.disable()

    # copy it to another texture
    glBindTexture(GL_TEXTURE_2D, texID2)
    glCopyTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, 0, 0, X, Y, 0)    
    glFlush()

def mainloop():
    glClearColor(0, 0, 0, 1)
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)

    glViewport(0, 0, X, Y)
    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()

    draw()
    
    for ev in pygame.event.get():
        if ev.type == QUIT: sys.exit()
        if ev.type == KEYDOWN: sys.exit()
        
    pygame.display.flip()


if __name__ == '__main__':
    init()
    while 1:
        mainloop()
        time.sleep(0.0005)
