from OpenGL.GL import *
from OpenGL.GLU import *
import pygame
from pygame.locals import *
import sys

class World:
    def __init__(self):

        self.initialize_state()

        self.load_textures()

    def initialize_state(self):
        self.theta = 0

    def load_textures(self):
        # slightly different from C syntax
        self.textureId = glGenTextures(1)

        # load our texture from a file
        texture = pygame.image.load('texture.bmp')
        # set the current 2D texture ID to the one we just made
        glBindTexture(GL_TEXTURE_2D, self.textureId)
        # helper function to create mipmaps for us
        gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGB,
                          texture.get_width(), texture.get_height(),
                          GL_RGB, GL_UNSIGNED_BYTE,
                          pygame.image.tostring(texture, 'RGB', 1))
        # set magnification and minification filters
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER,
                        GL_LINEAR)
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,
                        GL_LINEAR_MIPMAP_LINEAR)


    def draw(self):
        # first, clear the screen
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)

        # set the transformation
        glMatrixMode(GL_MODELVIEW)
        glPushMatrix()
        glRotatef(self.theta, 3, 2, 1)

        # set which texture we want
	glBindTexture(GL_TEXTURE_2D, self.textureId)

        # begin drawing
        glBegin(GL_QUADS)

        # textured face
	glColor3f(1, 1, 1)
	glNormal3f( 0,  0,  1)
        
        glTexCoord2f(0, 2)
	glVertex3f(-1, -1,  1)
        
	glTexCoord2f(2, 2)
	glVertex3f( 1, -1,  1)
        
        glTexCoord2f(2, 0)
	glVertex3f( 1,  1,  1)

	glTexCoord2f(0, 0)
	glVertex3f(-1,  1,  1)

        # non textured faces
	glColor3f(0.4, 0.4, 1)
	glNormal3f( 0,  0, -1)
	glVertex3f(-1, -1, -1)
	glVertex3f(-1,  1, -1)
	glVertex3f( 1,  1, -1)
	glVertex3f( 1, -1, -1)
        
	glColor3f(0.4, 1.0, 0.4)
	glNormal3f( 1,  0,  0)
	glVertex3f( 1, -1, -1)
	glVertex3f( 1,  1, -1)
	glVertex3f( 1,  1,  1)
	glVertex3f( 1, -1,  1)

	glNormal3f(-1,  0,  0)
	glVertex3f(-1, -1, -1)
	glVertex3f(-1,  1, -1)
	glVertex3f(-1,  1,  1)
	glVertex3f(-1, -1,  1)
        
	glColor3f(1.0, 0.4, 0.4)
	glNormal3f( 0,  1,  0)
	glVertex3f(-1,  1, -1)
	glVertex3f(-1,  1,  1)
        glVertex3f( 1,  1,  1)
        glVertex3f( 1,  1, -1)

	glNormal3f( 0, -1,  0)
	glVertex3f(-1, -1, -1)
	glVertex3f(-1, -1,  1)
	glVertex3f( 1, -1,  1)
	glVertex3f( 1, -1, -1)
	glEnd()

        # restore our matrix state
        glPopMatrix()

    def update(self):
        self.theta += 1

    def handleEvents(self):
        for event in pygame.event.get():
            if event.type == QUIT:
                pygame.quit()
                sys.exit(0)
            elif event.type == KEYDOWN:
                if event.key == K_ESCAPE:
                    pygame.quit()
                    sys.exit(0)
                else:
                    self.theta += 10
       
