import os, sys
import pygame
from pygame.locals import *
from OpenGL.GL import *
from OpenGL.GLU import *

from demoworld import *

def setup_OpenGL():
    # OpenGL setup
    glViewport(0,0,800,600)

    # projection matrix
    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    # set up our frustum
    gluPerspective(45, 4.0/3, 0.1, 100)
    # point our eye at a location
    gluLookAt(0, 0, 5,
              0, 0, 0,
              0, 1, 0)

    # model view matrix
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()

    # set the options we want
    glEnable(GL_DEPTH_TEST)
    glEnable(GL_LIGHTING)
    glEnable(GL_LIGHT0)
    glEnable(GL_COLOR_MATERIAL)
    glEnable(GL_TEXTURE_2D)

    # set the light
    position = [2,2,5,1]
    color = [1,1,1,1]
    glLightfv(GL_LIGHT0, GL_POSITION, position)
    glLightfv(GL_LIGHT0, GL_DIFFUSE, color)


# get pygame (SDL wrapper) to initialize the window
pygame.init()
flags = pygame.OPENGL | pygame.DOUBLEBUF | pygame.FULLSCREEN
pygame.display.set_mode((800,600),flags,32)

setup_OpenGL()

# instantiate our world
world = World()

while True:
    world.handleEvents()
    world.update()
    world.draw()

    pygame.display.flip()
    pygame.time.wait(30)
